

def convert_votes_to_vecs(profile):
    # for each project list all voters that approve it
    projects = {}
    for i, vote in enumerate(profile):
        for project in vote:
            if project not in projects:
                projects[project] = []
            projects[project].append(i)
    # get all possible voters
    voters = set(range(len(profile)))
    # create a vector for each project
    vec_profile = []

    # sort projects by their id
    projects = dict(sorted(projects.items(), reverse=True))
    for project in projects:
        vec_vote = [0] * len(voters)
        for voter in projects[project]:
            vec_vote[voter] = 1
        vec_profile.append(vec_vote)
    return vec_profile, list(projects.keys())


def convert_profiles_to_vec_profiles(profiles):
    vec_profiles = {}
    names = {}
    for profile_id in profiles:
        vec_profiles[profile_id], names[profile_id] = convert_votes_to_vecs(profiles[profile_id])
    return vec_profiles, names


def convert_vec_to_set(vec):
    return set([i for i, x in enumerate(vec) if x == 1])